/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskDefaultTableModel;
import filenet.vw.apps.taskman.images.VWImageLoader;
import filenet.vw.apps.taskman.pa.PADataFieldNode;
import filenet.vw.apps.taskman.pa.PADataFieldsNode;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.base.VWDebug;
import java.util.Vector;
import javax.swing.ImageIcon;

public class PADataFieldsTableModel
extends VWTaskDefaultTableModel {
    public static final int COL_UNIQUE_NAME = 0;
    public static final int COL_FIELD_NAME = 1;
    public static final int COL_FIELD_TYPE = 2;
    public static final int COL_MEASURE = 3;

    public PADataFieldsTableModel(PADataFieldsNode node) {
        super(node);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            if (rowIndex > super.getRowCount() - 1) {
                return null;
            }
            if (columnIndex > super.getColumnCount() - 1) {
                return null;
            }
            PADataFieldNode node = (PADataFieldNode)super.getNodeAt(rowIndex);
            if (node != null) {
                switch (columnIndex) {
                    case 0: {
                        return node;
                    }
                    case 1: {
                        return node.getFieldName();
                    }
                    case 2: {
                        return VWFieldType.getLocalizedString(node.getFieldType());
                    }
                    case 3: {
                        if (node.isMeasure()) {
                            return VWImageLoader.createImageIcon("check.gif");
                        }
                        return null;
                    }
                }
            }
        }
        catch (VWException e) {
            VWDebug.logException(e);
        }
        return null;
    }

    public Class getColumnClass(int index) {
        Class colClass = null;
        switch (index) {
            case 0: {
                colClass = VWTaskBaseNode.class;
                break;
            }
            case 3: {
                colClass = ImageIcon.class;
                break;
            }
            default: {
                colClass = String.class;
            }
        }
        return colClass;
    }

    protected Vector constructColumns() {
        Vector<String> headers = new Vector<String>();
        headers.addElement(VWResource.UniqueName);
        headers.addElement(VWResource.Field);
        headers.addElement(VWResource.FieldType);
        headers.addElement(VWResource.Measure);
        return headers;
    }
}

